/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import jclass.bwt.JCTextArea;

public class CutPasteTextArea
extends JCTextArea
implements ClipboardOwner {
    private Dimension preferredSize;

    public CutPasteTextArea(int n, int n2) {
        this("", n, n2);
    }

    public CutPasteTextArea(String string, int n, int n2) {
        super("", n, n2);
    }

    public void copyToClipboard(Clipboard clipboard) {
        StringSelection stringSelection = new StringSelection(this.getSelectedText());
        clipboard.setContents(stringSelection, this);
    }

    public void cutToClipboard(Clipboard clipboard) {
        StringSelection stringSelection = new StringSelection(this.getSelectedText());
        clipboard.setContents(stringSelection, this);
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        String string = this.getText();
        String string2 = null;
        if (n2 >= 0) {
            string2 = n == 0 ? string.substring(n2) : String.valueOf(string.substring(0, n)) + string.substring(n2);
            this.setText(string2);
        }
        this.repaint();
    }

    public void pasteFromClipboard(Clipboard clipboard) {
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                String string2 = this.getText();
                String string3 = null;
                if (string2.length() > 0) {
                    int n = this.getCaretPosition();
                    string3 = n > 0 ? String.valueOf(string2.substring(0, n)) + string : string;
                    if (n < string2.length()) {
                        string3 = string3.concat(string2.substring(n));
                    }
                    this.setText(string3);
                } else {
                    this.setText(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            this.repaint();
            return;
        }
        System.out.println("Data flavor not supported");
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("lost clipboard ownership");
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void setPreferredSize(int n, int n2) {
        this.preferredSize = new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public Dimension getMinimumSize() {
        return this.preferredSize;
    }
}

